#include<stdlib.h>
#include<stdio.h>
#include<string.h>
#include<math.h>

#define randomCoil 0
#define helix 1
#define sheet 2

typedef struct atomo{
	int label; /*struttura secondaria del residuo a cui l'elemento appartiene*/
	char resName[4]; /*nome del residuo amminoacidico a cui l'atomo appartiene*/
	int resSeq; /*riferimento incrociato alla rispettiva struttura secondaria*/
   	float x;
	float y;
	float z;
    	char element; /*simbolo dell' atomo (N.B.: il Carbonio Alfa è memomorizzato con 'A')*/
	}Atomo;
	
void stampaArrayAtomi(Atomo* A, int n){
	int i;	
	for(i=0; i<n; i++){
		printf("ATOM\t");
		if((A+i)->label == 0){
			printf("%d\t", (A+i)->label);
		}
		else if((A+i)->label == helix){
			printf("helix\t");
		}
		else if((A+i)->label == sheet){
			printf("sheet\t");
		}	
		printf("%s\t", (A+i)->resName);
		printf("%d\t", (A+i)->resSeq);
		printf("%8.3f\t", (A+i)->x);
		printf("%8.3f\t", (A+i)->y);
		printf("%8.3f\t", (A+i)->z);
		printf("%c\n", (A+i)->element);
	}
}
	
Atomo* arrayFromFile(char* NOMEFILE, int* n, int** chainType){
	
    	FILE * filep = fopen(NOMEFILE, "r");
   
    	char* line = malloc(100 * sizeof(char));
	char* stringa = malloc(5 * sizeof(char));	
	size_t lineSize;
    	ssize_t read_bytes;
	char* aux = malloc(200 * sizeof(char));		
	char* temp;

	Atomo* A = (Atomo*) malloc(10000 * sizeof(Atomo));

	*chainType = (int*) malloc(2000 * sizeof(int)); /*mi indica la struttura secondaria al variare del residuo*/
	int i;
	for(i = 0; i < 2000; i++){
		(*chainType)[i] = randomCoil;
	}
	
	//HELIX
	while(strcmp(stringa , "HELIX") != 0){
    		read_bytes = getline(&line, &lineSize, filep);
        	stringa = strncpy(stringa, line , 5);
        }
	
	int initSeqNum;
	int endSeqNum;
	aux = line + 22;
	temp = strtok(aux, " ");
	initSeqNum = atoi(temp) - 1;
	aux = line + 34;
	temp = strtok(aux, " ");
	endSeqNum = atoi(temp) - 1;
	
	for(i = initSeqNum; i <= endSeqNum; i++){
		(*chainType)[i] = helix;
	}

	while(strcmp(stringa , "HELIX") == 0){
    		read_bytes = getline(&line, &lineSize, filep);
        	stringa=strncpy(stringa, line , 5);
		if(strcmp(stringa , "HELIX") == 0){
			aux = line + 22;
			temp = strtok(aux, " ");
			initSeqNum = atoi(temp) - 1;
			aux = line + 34;
			temp = strtok(aux, " ");
			endSeqNum = atoi(temp) - 1;
	
			for(i = initSeqNum; i <= endSeqNum; i++){
				(*chainType)[i] = helix;
			}
        	}
	}
	
	//SHEET
	while(strcmp(stringa , "SHEET") != 0){
    		read_bytes = getline(&line, &lineSize, filep);
        	stringa=strncpy(stringa, line , 5);
        }
	
	aux = line + 22;
	temp = strtok(aux, " ");
	initSeqNum = atoi(temp) - 1;
	aux = line + 34;
	temp = strtok(aux, " ");
	endSeqNum = atoi(temp) - 1;
	
	int j;
	for(j = initSeqNum; j <= endSeqNum; j++){
		(*chainType)[j] = sheet;
	}

	while(strcmp(stringa , "SHEET") == 0){
    		read_bytes = getline(&line, &lineSize, filep);
        	stringa=strncpy(stringa, line , 5);
		if(strcmp(stringa , "SHEET") == 0){
			aux = line + 22;
			temp = strtok(aux, " ");
			initSeqNum = atoi(temp) - 1;
			aux = line + 34;
			temp = strtok(aux, " ");
			endSeqNum = atoi(temp) - 1;
	
			for(j = initSeqNum; j <= endSeqNum; j++){
				(*chainType)[j] = sheet;
			}
        	}
	}
	
	//ATOM
	while(strcmp(stringa , "ATOM ") != 0){
    		read_bytes = getline(&line, &lineSize, filep);
        	stringa=strncpy(stringa, line , 5);
        }
	
	aux = line + 13;
	temp = strtok(aux, " ");
		
	temp = strtok(NULL, " ");
	strcpy(A->resName, temp);

	aux = line + 23;
	temp = strtok(aux, " ");
	A->resSeq = atoi(temp) - 1;
	A->label = (*chainType)[(A->resSeq)];

	aux = line + 30;
	temp = strtok(NULL, " ");
	A->x = atof(temp);
	temp = strtok(NULL, " ");
	A->y = atof(temp);
	temp = strtok(NULL, " ");
	A->z = atof(temp);
	aux = line + 77;
	A->element = *aux;

	int k;
	k = 1;
	while(strcmp(stringa , "ATOM ") == 0){
    		read_bytes = getline(&line, &lineSize, filep);
        	stringa=strncpy(stringa, line , 5);

		if(strcmp(stringa , "ATOM ") == 0){
			aux = line + 13;
			temp = strtok(aux, " ");
			if(strcmp(temp, "CA") == 0){
				temp = strtok(NULL, " ");
				strcpy((A+k)->resName, temp);

				aux = line + 23;
				temp = strtok(aux, " ");
				(A+k)->resSeq = atoi(temp) - 1;
				(A+k)->label = (*chainType)[(A->resSeq)];

				aux = line + 30;
				temp = strtok(NULL, " ");
				(A+k)->x = atof(temp);
				temp = strtok(NULL, " ");
				(A+k)->y = atof(temp);
				temp = strtok(NULL, " ");
				(A+k)->z = atof(temp);
				(A+k)->element = 'A';
				
				k++;
			}
			else{
				temp = strtok(NULL, " ");
				strcpy((A+k)->resName, temp);

				aux = line + 23;
				temp = strtok(aux, " ");
				(A+k)->resSeq = atoi(temp) - 1;
				(A+k)->label = (*chainType)[(A->resSeq)];

				aux = line + 30;
				temp = strtok(NULL, " ");
				(A+k)->x = atof(temp);
				temp = strtok(NULL, " ");
				(A+k)->y = atof(temp);
				temp = strtok(NULL, " ");
				(A+k)->z = atof(temp);
				aux = line + 77;
				(A+k)->element = *aux;

				k++;
			}
       		}
	}
	//fclose(filep);
	//free(aux1);
	//free(line);
	//free(A);
	//free(stringa);
	//free(chainType);
	
	*n = k;
	return A;
}
