#include<time.h>
#include<stdlib.h>
#include<stdio.h>


//////////////////////////////////////////////////////
//implementazione pila
struct nodoPila{
		int indiceAtomo;
		struct nodoPila* succ;
	};

typedef struct nodoPila* Pila;

void stampaPila(Pila P){
	while(P != NULL){
		printf("%d  ", P->indiceAtomo);
		P = P->succ;
	}
	printf("\n");
}

Pila pilaVuota(){
	Pila P = malloc(sizeof(struct nodoPila));
	P = NULL;
	return P;
}

Pila pilaStart(int v){
	Pila P = malloc(sizeof(struct nodoPila));
	P->indiceAtomo = v;
	P->succ = NULL;
	return P;
}

void push(Pila* P, int v){
	Pila aux;
	
	aux = malloc(sizeof(struct nodoPila));
	aux->indiceAtomo = v;
	aux->succ = *P;
	*P = aux;	
}

int pop(Pila* P){
	Pila aux;
	int h;
	if(*P != NULL){
		h = (*P)->indiceAtomo;
		aux = *P;
		*P = (*P)->succ;
		free(aux);
	}
	return h;
}

/*inserisce nella pila i vicini di un atomo in ordine contrario*/
void inserisciVicini(Pila* P, Arco* vicini){
	int i = 0;
	int ultimo = 0;	
	
	while( (vicini+i)->indice != -1){
		i++;
	}

	ultimo = i-1;
	for(i = ultimo; i >= 0; i--){
		push(P, (vicini+i)->indice);	
	}
}

////////////////////////////////////////////////////////
//implementazione Struttura Dati per il SICC

typedef struct nodo{
	int indice;
	int immagine;
	Pila nonScelte;
	struct nodo* succ;
}Nodo;

struct sicc{
	Nodo* nodiSicc;
	int dim;
};

typedef struct sicc* Sicc;

void stampaSicc(Sicc S){
	Nodo* aux;
	int i = 0;
	aux = S->nodiSicc;
	while(i < S->dim){
		printf("%d--->%d  ", aux->indice, aux->immagine);
		//printf("\n PILA per %d:  ", aux->indice);
		//stampaPila(aux->nonScelte);
		aux = aux->succ;
		i++;
	}
	printf("\n\n\n");	
}

Sicc siccVuoto(void){
	Sicc S;
	Pila T;
	S = malloc(sizeof(struct sicc));
	S->nodiSicc = NULL;
	S->dim = 0;
	return S;
}

int isInSicc(Sicc S, int u){
	Nodo* aux = S->nodiSicc;	
	int trovato = 0;

	while(aux != NULL && !trovato){
		if(aux->indice == u){
			trovato = 1;	
		}
		else{
			aux = aux->succ;
		}
	}
	return trovato;
}

int isInSiccImm(Sicc S, int v){
	Nodo* aux = S->nodiSicc;	
	int trovato = 0;

	while(aux != NULL && !trovato){
		if(aux->immagine == v){
			trovato = 1;	
		}
		else{
			aux = aux->succ;
		}
	}
	return trovato;
}

void inserisciInSicc(Sicc S, int u, int v , Pila T){
	Nodo* ultimo;	
	Nodo* aux;
	
	aux = (Nodo*) malloc(sizeof(Nodo));
	aux->indice = u;
	aux->immagine = v;
	aux->nonScelte = T;
	aux->succ = NULL;
	
	if(S->dim == 0){
		S->nodiSicc = aux;
	}
	else{	
		ultimo = S->nodiSicc;	
		while (ultimo->succ != NULL){
			ultimo = ultimo->succ;
		}
		ultimo->succ = aux;
	}
		
	(S->dim)++;
}

Nodo estraiUltimo(Sicc S){
	Nodo* aux;
	Nodo temp;
	//stampaSicc(S);
	if(S->dim > 0){
		aux = S->nodiSicc;
		if(aux->succ == NULL){
			temp.indice = aux->indice;
			temp.immagine = aux->immagine;
			temp.nonScelte = aux->nonScelte;
			return temp;
		}	
		while(aux->succ != NULL){
			aux = aux->succ;
			//printf("%d\n", aux->indice);
		}
		temp.indice = aux->indice;
		temp.immagine = aux->immagine;
		temp.nonScelte = aux->nonScelte;
		return temp; 
	}
}

void cancellaDalSicc(Sicc S){
	Nodo* aux;
	
	if(S->dim > 0){
		aux = S->nodiSicc;
		if(aux->succ == NULL){
			free(aux);
			aux = NULL;
		}
		else{
			while(((aux->succ)->succ) != NULL){
				aux = aux->succ;
			}
			free(aux->succ);
			aux->succ = NULL;
		}
	
		(S->dim)--;
	}
	
}

///////////////////////////////////////////////////////
//Euristica per la ricerca della dimensione massima dei Sicc di grafi G1 e G2

/*dato un CARBONIO ALFA nel primo grafo trova la sua immagine nel secondo grafo*/
void trovaImmaginiCAStart(Atomo* X, int* C1, int h, int cardinalitaG2 , Atomo* Y, int* C2, Pila* Q){
	int i = 0;
	while( i < cardinalitaG2 ){ 
		if((Y+i)->element == (X+h)->element  &&  strcmp((Y+i)->resName ,(X+h)->resName) == 0  &&  C2[(Y+i)->resSeq] == C1[(X+h)->resSeq]){
			push(Q, i);
		}
		i++;
	}
}

/*mi trova la posizione di h nell' array dei vicini di un dato atomo*/
int trovaPosizione(Arco* vicini, int h){
	int r = 0;
	
	while( (vicini +r)->indice != h ){
		r++;
	}
	return r;
}

/*mi dice se v è un vicino di un dato atomo*/
int sonoVicini(Arco* vicini, int v){
	int r = 0;
	
	while( (vicini +r)->indice != v && (vicini +r)->indice != -1 ){
		r++;
	}
	return ((vicini +r)->indice == v); 
}

/*vicini1 = "vicini di h", vicini2 = "vicini di k"*/
int isomorfismo(Arco* vicini1, Arco* vicini2, Sicc S){
	int tutti = 1;	
	Nodo* aux;
	int u;
	int v;
	int r;
	int s;

	int i = 0;
	if(S->dim > 1){
		aux = S->nodiSicc;
		u = aux->indice;
		v = aux->immagine;
		if(sonoVicini(vicini1, u) != sonoVicini(vicini2, v)){
			return 0;
		}
		else if(sonoVicini(vicini1, u)){
			r = trovaPosizione(vicini1, u);
			s = trovaPosizione(vicini2, v);
			if((vicini1 +r)->tipo != (vicini2 +s)->tipo){
				return 0;
			}
		}
		i = 1; 
		while(i < S->dim && tutti == 1){
			aux = aux->succ;
			u = aux->indice;
			v = aux->immagine;
			if(sonoVicini(vicini1, u) != sonoVicini(vicini2, v)){
				tutti = 0;
			}
			else if(sonoVicini(vicini1, u)){
				r = trovaPosizione(vicini1, u);
				s = trovaPosizione(vicini2, v);
				if((vicini1 +r)->tipo != (vicini2 +s)->tipo){
					tutti = 0;
				} 
			}
			i++;
		}
	}
	return tutti;	
}

/*cerca la prima immagine buona di h tra vicini3 . vicini1 = "vicini di prec",   vicini2 = "vicini di h",   vicini3 = "vicini di k"*/
void trovaImmaginiCA(Atomo* X, Arco* vicini1, Arco* vicini2, int* C1, int prec, int h, Graph G2, Atomo* Y, Arco* vicini3, int* C2, Sicc S, Pila* T){
	int i = 0;
	int j = (vicini3 +i)->indice;
	int r = trovaPosizione(vicini1, h);  /*posizione di h nella lista di adiacenza di prec (serve solo per i legami)*/	

	while( j > -1 ){
		if( isInSiccImm(S, j) == 0  &&  (Y+j)->element == (X+h)->element  &&  (vicini3 +i)->tipo == (vicini1 +r)->tipo ){
			if( /*strcmp((Y+j)->resName , (X+h)->resName) == 0  &&*/  C2[(Y+j)->resSeq] == C1[(X+h)->resSeq] ){
				if( isomorfismo(vicini2, (G2->vicini)[j], S) ){
					push(T, j);
				}
			}
		}
		i++;
		j = (vicini3 +i)->indice;
	}
}

void trovaImmagini(Atomo* X, Arco* vicini1, Arco* vicini2, int* C1, int prec, int h, Graph G2, Atomo* Y, Arco* vicini3, int* C2, Sicc S, Pila* T){
	int i = 0;
	int j = (vicini2 +i)->indice;
	int r = trovaPosizione(vicini1, h);  /*posizione di h nella lista di adiacenza di prec (SERVE SOLO PER I LEGAMI)*/	

	while( j > -1 ){
		if( isInSiccImm(S, j) == 0  &&  (vicini3 +i)->tipo == (vicini1 +r)->tipo ){
			if( /*strcmp((Y+j)->resName , (X+h)->resName) == 0  &&*/  C2[(Y+j)->resSeq] == C1[(X+h)->resSeq] ){
				if( isomorfismo(vicini2, (G2->vicini)[j], S) ){
					push(T, j);
				}
			}
		}
		i++;
		j = (vicini3 +i)->indice;
	}
}

void cambiaImmagine(Sicc* S, Pila *T, int* h, int* k){
	Nodo u;	

	u = estraiUltimo(*S);
	*T = u.nonScelte;
	
	while(*T == NULL){
		cancellaDalSicc(*S);
		u = estraiUltimo(*S);
		*T = u.nonScelte;
	}
	*h = u.indice;
	*k = pop(T);
	cancellaDalSicc(*S);
}

/*calcola la dimensione massima del SICC fissata una radice e la corrispettiva immagine */
void dimMaxSiccRadice(Graph G1, Atomo* X, int* C1, Graph G2, Atomo* Y, int* C2, int radice, int immagine, Pila R, Sicc* S){
	Pila P;
	Pila T; //Pila delle immagini non scelte per un dato nodo

	int trovato = 0;
	
	int h = radice;
	int k = immagine;
	trovato = 1;

	P = pilaStart(h);
	
	h = pop(&P);

	inserisciInSicc(*S, h, k, R);

	inserisciVicini(&P, (G1->vicini)[h]);
	//stampaPila(P);	
	
	int prec;
	while(P != NULL){
		if(trovato == 1){	
			prec = h;
		}
		h = pop(&P);
		trovato = 0;
		if(isInSicc(*S, h) == 0){
			if((X+h)->element == 'A'){
				T = pilaVuota();
				trovaImmaginiCA(X, (G1->vicini)[prec], (G1->vicini)[h], C1, prec, h, G2, Y, (G2->vicini)[k], C2, *S, &T);
				//stampaPila(T);
				if(T != NULL){
					k = pop(&T);
					trovato = 1;
					inserisciInSicc(*S, h, k, T);
					inserisciVicini(&P, (G1->vicini)[h]);
				}
			}
			else{
				T = pilaVuota();
				trovaImmagini(X, (G1->vicini)[prec], (G1->vicini)[h], C1, prec, h, G2, Y, (G2->vicini)[k], C2, *S, &T);
				//stampaPila(T);
				if(T != NULL){
					k = pop(&T);
					trovato = 1;
					inserisciInSicc(*S, h, k, T);
					inserisciVicini(&P, (G1->vicini)[h]);
				}
			}
		}
			//stampaPila(P);
	}
	//stampaSicc(*S);
}

void dimMaxSicc(Graph G1, Atomo* X, int* C1, Graph G2, Atomo* Y, int* C2, int start, int tempo, int* dimensioneEuristica){
	clock_t t0 = clock();
	Pila T;
	Sicc S = siccVuoto();	

	int h; 
	int k;	

	h = start;
	while((X+h)->element != 'A'){
		h++;
	}
	start = h;

	T = pilaVuota();
	trovaImmaginiCAStart(X, C1, h, G2->n, Y, C2, &T);	
	k = pop(&T);

	dimMaxSiccRadice(G1, X, C1, G2, Y, C2, h, k, T, &S);
	if(S->dim > *dimensioneEuristica){
		*dimensioneEuristica = S->dim;
		printf("%d\n", *dimensioneEuristica);
		stampaSicc(S);
	}
	
	cambiaImmagine(&S, &T, &h, &k);

	dimMaxSiccRadice(G1, X, C1, G2, Y, C2, h, k, T, &S);
	if(S->dim > *dimensioneEuristica){
		*dimensioneEuristica = S->dim;
		printf("%d\n", *dimensioneEuristica);
		stampaSicc(S);
	}
	while((S->nodiSicc)->nonScelte != NULL){
		cambiaImmagine(&S, &T, &h, &k);

		dimMaxSiccRadice(G1, X, C1, G2, Y, C2, h, k, T, &S);
		if(S->dim > *dimensioneEuristica){
			*dimensioneEuristica = S->dim;
			printf("%d\n", *dimensioneEuristica);
			stampaSicc(S);
		}
	}
	

	clock_t t;
	while(t < tempo){
		h = start + 1;
		while((X+h)->element != 'A' && h < G1->n){
			h++;
		}
		if((X+h)->element == 'A'){
			free(S);
			S = siccVuoto();

			start = h;
			
			T = pilaVuota();
			trovaImmaginiCAStart(X, C1, h, G2->n, Y, C2, &T);		
			k = pop(&T);

			dimMaxSiccRadice(G1, X, C1, G2, Y, C2, h, k, T, &S);
			if(S->dim > *dimensioneEuristica){
					*dimensioneEuristica = S->dim;
					printf("%d\n", *dimensioneEuristica);
					stampaSicc(S);
			}
	
			cambiaImmagine(&S, &T, &h, &k);

			dimMaxSiccRadice(G1, X, C1, G2, Y, C2, h, k, T, &S);
			if(S->dim > *dimensioneEuristica){
				*dimensioneEuristica = S->dim;
				printf("%d\n", *dimensioneEuristica);
				stampaSicc(S);
			}

			while((S->nodiSicc)->nonScelte != NULL){
				cambiaImmagine(&S, &T, &h, &k);

				dimMaxSiccRadice(G1, X, C1, G2, Y, C2, h, k, T, &S);
				if(S->dim > *dimensioneEuristica){
					*dimensioneEuristica = S->dim;
					printf("%d\n", *dimensioneEuristica);
					stampaSicc(S);
				}
				t = clock();
				t = ((t - t0)/60)/CLOCKS_PER_SEC;
				if(t >= tempo){
					return;
				}
			}
		}
		else{
			return;
		}
	}
}
