#include<stdlib.h>
#include<stdio.h>
#include<string.h>

typedef struct arco{
	int indice;
	int tipo;
}Arco;

struct graph_t{
	int n; /*numero di nodi (etichettati da 0 a n-1)*/
    	Arco** vicini; /*vettore di n vettori di dim 30*/
};

typedef struct graph_t * Graph;

void stampaGrafoProteine(Graph G){
	int i, j;
	for(i = 0; i < (G->n) - 1; i++){
		printf("%d---", i);
		j = 0;
		while( (((G->vicini)[i])+j)->indice != -1 ){
			if((((G->vicini)[i])+j)->tipo == 1){
				printf("*%d, ", (((G->vicini)[i])+j)->indice);
			}
			else{
				printf("%d, ", (((G->vicini)[i])+j)->indice);
			}
			j++;
		}
		printf("\n"); 
	}
}

double distanzaEuclidea(Atomo* A, int i, int j){
	double d;
	double X, Y, Z;
	X = ((A+i)->x) - ((A+j)->x);
	Y = ((A+i)->y) - ((A+j)->y);
	Z = ((A+i)->z) - ((A+j)->z);
	d = pow(X,2) + pow(Y,2) + pow(Z,2);
	return sqrt(d);
}

void inserisciNonCovalente(Arco* array, int dim, int x)
{
    	int i = 0;
    	while(i < dim)
    	{
        	if( (array + i)->indice == -1){
			(array + i)->indice = x;
			(array + i)->tipo = 0;
        		return;
		}
        	i = i+1;
    	}
}

void inserisciCovalente(Arco* array, int dim, int x)
{
    	int i = 0;
    	while(i < dim)
    	{
        	if( (array + i)->indice == -1){
			(array + i)->indice = x;
			(array + i)->tipo = 1;
        		return;
		}
        	i = i+1;
    	}
}


//costriamo un grafo 'vuoto' con num = #atomi 
Graph grafoVuoto(int num){
	int i;
    	Graph G;
	G = malloc(sizeof(struct graph_t));
    	
	G->n = num;

    	G->vicini = (Arco**) malloc(num * sizeof(Arco*));
    	for(i = 0; i < num; i++){
        	(G->vicini)[i] = NULL;
        }
	
   	return G;
}

Graph graphFromArray(Atomo* A, int num){
	int i;
	int j;
	Graph G;
	
	G = grafoVuoto(num);

	for(i = 0; i < (G->n) - 1; i++){
        	(G->vicini)[i] = (Arco*) malloc(30 * sizeof(Arco));
	   	for(j=0; j < 30; j++){
			(((G->vicini)[i])+j)->indice = -1;
			(((G->vicini)[i])+j)->tipo = -1;
		}
	}

	for(i = 0; i < (G->n) - 1; i++){
		for(j = i+1; j < (G->n) - 1; j++){ 
			if(distanzaEuclidea(A, i, j) >= 1 && distanzaEuclidea(A, i, j) <= 2){
				inserisciCovalente((G->vicini)[i], 30, j);
        			inserisciCovalente((G->vicini)[j], 30, i);
			}
			else if(distanzaEuclidea(A, i, j) > 2 && distanzaEuclidea(A, i, j) <= 3.2){
				inserisciNonCovalente((G->vicini)[i], 30, j);
        			inserisciNonCovalente((G->vicini)[j], 30, i);
			}
		}
	}
	
	return G;
}
