#include"arrayAtomi.h"
#include"grafoProteine.h"
#include"dimMaxSicc.h"

/*
Esempio di compilazione ed esecuzione
gcc main.c -lm -o main && ./main 1ald.pdb 1fcb.pdb
*/
		
int main(int argc, char** argv){
	printf("\n\n-------Euristica per la ricerca della dimensione massima del SICC-------\n\n");

	int numeroAtomi1, numeroAtomi2;
	int* chainType1;
 	int* chainType2;
	
	Atomo* arrayAtomi1 = arrayFromFile(argv[1], &numeroAtomi1, &chainType1);
	Graph graph1 = graphFromArray(arrayAtomi1, numeroAtomi1);
	//stampaArrayAtomi(arrayAtomi1, numeroAtomi1);
	//stampaGrafoProteine(graph1);
	//printf("numeroAtomi1 %d\n", numeroAtomi1);
	
	
	Atomo* arrayAtomi2 = arrayFromFile(argv[2], &numeroAtomi2, &chainType2);
	Graph graph2 = graphFromArray(arrayAtomi2, numeroAtomi2);
	//stampaArrayAtomi(arrayAtomi2, numeroAtomi2);
	//stampaGrafoProteine(graph2);
	//printf("numeroAtomi2 %d\n", numeroAtomi2);


	printf(">Inserire il numero seriale dell' atomo da cui partire: da 0 a %d\n\n", numeroAtomi1 - 20);
	int start;
	scanf("%d", &start);

	printf("\n\n>Inserire quanti minuti attendere per il calcolo\n\n");
	int tempo;
	scanf("%d", &tempo);

	int dimensioneEuristica = 0; 
	
	clock_t inizio = clock();
	dimMaxSicc(graph1, arrayAtomi1, chainType1, graph2, arrayAtomi2, chainType2, start, tempo, &dimensioneEuristica);
	clock_t fine = clock();

	int minuti = ((fine - inizio)/60)/CLOCKS_PER_SEC;
	int secondi = (fine - inizio)/CLOCKS_PER_SEC;
	printf("Dimensione Euristica: %i , trovata in %i minuti e %i secondi. \n", dimensioneEuristica, minuti, secondi % 60);

	return 0;
}

